with Flts;
use Flts;

pragma Elaborate_all (Flts);

generic

  type Scalar is private;

  with procedure Copy(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Add(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Sum(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with procedure Diff(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with procedure Mult(R: in Flt; S: in out Scalar) is <>;

package Bisection is --- find approximate zeros of functions

  generic
    with function SignF(X: in Scalar) return Integer;
  procedure FindSigns(X0,X: in out Scalar; S0,S: out Integer); -- may not find sign change
                                                               --- general, but inefficient

  generic
    with function F(X: in Flt) return Flt;
  procedure Find_Signs(X1,X2: in out Flt; Y1,Y2: out Flt);     -- may not find sign change
                                                               --- specialized. works for polynomials whose zeros all all between (the initial) X1 and X2

  generic
    with function F(X: Scalar) return Flt;
  procedure FindZero(XN,XP: in out Scalar; Err: in out Radius); -- assuming F(XN)<0, F(XP)>0

  NSign: Positive :=   9; -- 2**NSign is the max number of steps in FindSigns
  NFind: Positive := 512; -- max number of bisections in FindZero

end Bisection;
