with Flts, Globals, Params.Names, Strings, Reps.Balls, Ints, Polynoms;
use Flts, Globals, Params, Strings, Reps, Reps.Balls, Ints;
with Params.Names, Matrices, Vectors, ScalVectors, Taylors2.Cheb.Fix;

pragma Elaborate_All (Flts,Globals,Params,Strings,Reps);
pragma Elaborate_All (Params.Names,Matrices,Vectors,ScalVectors, Taylors2.Cheb.Fix);

procedure Check_Bifpt(P: in Param) is

   package PN is new Params.Names(P => P, Trunc => False);
   use PN;

   subtype NumScalar is Rep;
   subtype Scalar is Ball;

   package NSV is new Vectors (Component => NumScalar);
   package NSM is new Matrices (Scalar => NumScalar);
   package NSSV is new ScalVectors (Scalar => NumScalar, SM => NSM, SV => NSV);

   package NTay is new Taylors2(PDeg => PDeg, Scalar => NumScalar, SM => NSM, SV => NSV);
   package NTC is new NTay.Cheb(CDeg => CDeg, RadC => RadC);
   package NFix is new NTC.Fix(T2C => T2C, T2W => T2W, SSV => NSSV, Mat_PackSize => Mat_PackSize);

   package SV is new Vectors (Component => Scalar);
   package SM is new Matrices (Scalar => Scalar);
   package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

   package Tay is new Taylors2(PDeg => PDeg, Scalar => Scalar, SM => SM, SV => SV);
   package TC is new Tay.Cheb(CDeg => CDeg, RadC => RadC);
   package Fix is new TC.Fix(T2C => T2C, T2W => T2W, SSV => SSV, Mat_PackSize => Mat_PackSize);


   Epsilon: constant Radius := 1.0e-15;

   NF: NTC.Traj;
   NM: NFix.QC_Matrix;
   F: TC.Traj;
   M: Fix.QC_Matrix;

begin

   Show("",P);
   NFix.ReadFHat(Prefix);
   NTC.Read(Input_Dir & Fix_Name & ".approx",NF);
   NFix.ApproxFix(NF,NM,Epsilon);
   NTC.Write(Output_Dir & Fix_Name & ".approx",NF);
   for I in NM'Range(1) loop
      for J in NM'Range(2) loop
         M(I,J) := Scal(Approx(NM(I,J)));
      end loop;
   end loop;
   NFix.SaveG(NF,Prefix);
   if Contr_PackSize>0 then
      Fix.ReadFHat(Prefix);
      TC.Read(Input_Dir & Fix_Name & ".approx",F);
      Fix.ContrFix(M,Contr_PackSize,F);
      TC.Write(Input_Dir & Fix_Name,F);
      Fix.SaveG(F,Prefix);
      if Prefix="BIF1" then Fix.ShowDer1; else Fix.ShowDer2; end if;
   end if;

end Check_Bifpt;
