
generic

  type Real is private;
  type Vector is array (Integer range <>) of Real;
  type Matrix is array (Integer range <>, Integer range <>) of Real;

  with function Scal(K: Integer) return Real is <>;
  with function "<"(S1,S2: Real) return Boolean is <>;
  with function "-"(S: Real) return Real is <>;
  with function "+"(S1,S2: Real) return Real is <>;
  with function "-"(S1,S2: Real) return Real is <>;
  with function "*"(S1,S2: Real) return Real is <>;
  with function "/"(S1,S2: Real) return Real is <>;
  with function "abs"(S: Real) return Real is <>;
  with function Sqrt(S: Real) return Real is <>;

package EisPack1 is --- adapted from eispack

  procedure tred1(n: in Integer; a: in out Matrix; d,e,e2: in out Vector);
  procedure tred2(n: in Integer; a: in Matrix; d,e: in out Vector; z: in out Matrix);
  procedure tql1(n: in Integer; d,e: in out Vector; ierr: out Integer);
  procedure tql2(n: in Integer; d,e: in out Vector; z: in out Matrix; ierr: out Integer);

private

  function dsign(a,b: Real) return Real;

  Zero_Real: constant Real := Scal(0);
  One_Real:  constant Real := Scal(1);
  Two_Real:  constant Real := Scal(2);

end EisPack1;
