with Ada.Text_IO;
use Ada.Text_IO;

pragma Elaborate_All(Ada.Text_IO);

package Globals is

  type Return_File_Access is access function return File_Access;

  Input_Dir:         constant String   := "data/";
  Output_Dir:        constant String   := "data/";
  Tmp_Dir:           constant String   := "tmpdata/";
  Pic_Dir:           constant String   := "pics/";

  CheckRange: Boolean := False;    -- for matrices and vectors
  Verbosity: aliased Natural := 0; -- 0: just error messages and important warnings
                                   -- 1: also high level program info
                                   -- 2: also TraceEnter and TraceLeave
                                   -- 3: also domain errors with info in numeric programs
                                   -- 4: more stuff
                                   -- 5: almost everything
                                   -- 6: insane

  Initial_Precision:      aliased Positive := 1024;
  NTasks:                 aliased Positive := 1;      -- default value
  Stack_Size:             aliased Positive := 2**30;  -- default value
  Primitive_Buffer_Size: constant Positive := 2**12;

  ArgIndex: Positive := 1;      -- used by GetArg, do not change
  Default_Output: Return_File_Access := Current_Output'Access;

  Domain_Error, Dimension_Error, Undefined, Not_Implemented, Sorry, Parity_Error, Inconsistent_Data, Not_Found: exception;

end Globals;
