with Logicals;
use Logicals;

pragma Elaborate_All (Logicals);

package MGeneric is --- component-wise matrix operations

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Modify1(C: in out Scalar);
  procedure MP_Modify1(M: in out Matrix);

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Modify2(C1,C2: in out Scalar);
  procedure MP_Modify2(M1,M2: in out Matrix);

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Map1(C1: in Scalar; C2: in out Scalar);
  procedure MP_Map1(M1: in Matrix; M2: in out Matrix);

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Map1(C1: in Scalar; C2: in out Scalar);
  function MF_Map1(M: Matrix) return Matrix;

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Map2(C1,C2: in Scalar; C3: in out Scalar);
  procedure MP_Map2(M1,M2: in Matrix; M3: in out Matrix);

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with procedure Map2(C1,C2: in Scalar; C3: in out Scalar);
  function MF_Map2(M1,M2: Matrix) return Matrix;

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with function BProperty(C: Scalar) return Boolean;
  function MF_BProperty(M: Matrix) return Boolean;

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with function LProperty(C: Scalar) return Logical;
  function MF_LProperty(M: Matrix) return Logical;

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with function BSimilar(C1,C2: Scalar) return Boolean;
  function MF_BSimilar(M1,M2: Matrix) return Boolean;

  generic
    type Scalar is private;
    type Matrix is array(Integer range <>, Integer range <>) of Scalar;
    with function LSimilar(C1,C2: Scalar) return Logical;
  function MF_LSimilar(M1,M2: Matrix) return Logical;

end MGeneric;
