with ScalVectors, Linear, Linear.Contr;

pragma Elaborate_All (ScalVectors,Linear.Contr);

generic

   T2C,T2W: in Radius;
   Mat_PackSize: in Positive;
   with package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

package Taylors2.Cheb.Fix is

   subtype SMatrix is SM.Matrix;

   procedure FMap(F: in Traj; GF: in out Traj);
   procedure Aux(F: in Traj; Y,Theta,Y2,SinTheta,SqrSinTheta,Sin2Theta,Sin4Theta,
                               Cos2Theta,Cos4Theta,SixYplus2,EightYplus6,DThCoeff: in out TayCheb);
   procedure DGMap(Y,Theta,Y2,SinTheta,SqrSinTheta,Sin2Theta,Sin4Theta,Cos2Theta,
                   Cos4Theta,SixYplus2,EightYplus6,DThCoeff: in TayCheb; H: in Traj; DGH: in out Traj);
   procedure DContrNorm(M: in SMatrix; F: in Traj; PackSize: in Positive; R: out Radius);
   procedure ContrFix(M: in SMatrix; PackSize: in Positive; F: in out Traj);

   package SV_Ops renames SSV.SV_Ops;
   package Lin is new Linear (Scalar => Scalar, SM => SM, SV => SV, Fun => Traj,
                              Mode => TrajMode, Modes => TrajModes);
   package Lin_Contr is new Lin.Contr (SSV => SSV);

   --- numerical
   procedure DerMatrix(F: in Traj; M: in out SMatrix);
   procedure ContrMatrix(F: in Traj; M: in out SMatrix);
   procedure ApproxFix(F: in out Traj; M: in out SMatrix; Eps: in Radius := Zero);
   procedure IterContr(F: in out Traj; M: in out SMatrix);

   procedure ScalProd(F,G: in Traj; S: in out TScalar);
   procedure Normalize(F: in out Traj);
   procedure IdMinusProjection(F: in out Traj);    --- F-(F,FHat)FHat
   procedure SaveG(F: in Traj; FileName: in String);
   procedure ShowDer1;
   procedure ShowDer2;
   function Interval(C,R: Flt; J: Positive) return TScalar; --- C + R*xJ
   procedure ReadFHat(FileName: in String);

   QC: TrajModes := Make(RadC,Mat_PackSize,True,True);   --- Simple and no Err modes
   subtype QC_Vector is SV.Vector(QC'Range);
   subtype QC_Matrix is SMatrix(QC'Range,QC'Range);

   MOmega2,M34Omega2,Lambda: TScalar;    --- defined during elaboration
   FHat,LambdaFHat: Traj;                --- defined during elaboration

end Taylors2.Cheb.Fix;
