with Logicals;
use Logicals;

pragma Elaborate_All (Logicals);

package VGeneric is --- component-wise vector operations

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Modify1(C: in out Component);
  procedure VP_Modify1(V: in out Vector);

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Modify2(C1,C2: in out Component);
  procedure VP_Modify2(V1,V2: in out Vector);

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Map1(C1: in Component; C2: in out Component);
  procedure VP_Map1(V1: in Vector; V2: in out Vector);

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Map1(C1: in Component; C2: in out Component);
  function VF_Map1(V: Vector) return Vector;

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Map2(C1,C2: in Component; C3: in out Component);
  procedure VP_Map2(V1,V2: in Vector; V3: in out Vector);

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with procedure Map2(C1,C2: in Component; C3: in out Component);
  function VF_Map2(V1,V2: Vector) return Vector;

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with function BProperty(C: Component) return Boolean;
  function VF_BProperty(V: Vector) return Boolean;

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with function LProperty(C: Component) return Logical;
  function VF_LProperty(V: Vector) return Logical;

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with function BSimilar(C1,C2: Component) return Boolean;
  function VF_BSimilar(V1,V2: Vector) return Boolean;

  generic
    type Component is private;
    type Vector is array(Integer range <>) of Component;
    with function LSimilar(C1,C2: Component) return Logical;
  function VF_LSimilar(V1,V2: Vector) return Logical;

end VGeneric;
