
package body Flts.Plotting is

  package Txt_IO renames Ada.Text_IO;

  procedure Plot2(F: in File_Type; R1,R2: in Flt) is
  begin
    Flt_IO.Put(F,R1,Plot_Fore,Plot_Aft,Plot_Exp);
    Txt_IO.Put(F," ");
    Flt_IO.Put(F,R2,Plot_Fore,Plot_Aft,Plot_Exp);
    New_Line(F);
  end Plot2;

  procedure Plot3(F: in File_Type; R1,R2,R3: in Flt) is
  begin
    Flt_IO.Put(F,R1,Plot_Fore,Plot_Aft,Plot_Exp);
    Txt_IO.Put(F," ");
    Flt_IO.Put(F,R2,Plot_Fore,Plot_Aft,Plot_Exp);
    Txt_IO.Put(F," ");
    Flt_IO.Put(F,R3,Plot_Fore,Plot_Aft,Plot_Exp);
    New_Line(F);
  end Plot3;

  procedure Plot(F: in File_Type; R: in Flt_Vec) is
  begin
    Flt_IO.Put(F,R(R'First),Plot_Fore,Plot_Aft,Plot_Exp);
    for K in R'First+1 .. R'Last loop
      Txt_IO.Put(F," ");
      Flt_IO.Put(F,R(K),Plot_Fore,Plot_Aft,Plot_Exp);
    end loop;
    New_Line(F);
  end Plot;

  procedure Open_Append(F: in out File_Type; FileName: in String) is
  begin
    Open(F,Append_File,FileName);
  exception
    when Name_Error => Create(F,Out_File,FileName);
  end Open_Append;

  procedure Append_Plot2(FileName: in String; R1,R2: in Flt) is
    F: File_Type;
  begin
    if FileName="" then
      Plot2(Standard_Output,R1,R2);
    else
      Open_Append(F,FileName);
      Plot2(F,R1,R2);
      Close(F);
    end if;
  end Append_Plot2;

  procedure Append_Plot3(FileName: in String; R1,R2,R3: in Flt) is
    F: File_Type;
  begin
    if FileName="" then
      Plot3(Standard_Output,R1,R2,R3);
    else
      Open_Append(F,FileName);
      Plot3(F,R1,R2,R3);
      Close(F);
    end if;
  end Append_Plot3;

  procedure Append_Plot(FileName: in String; R: in Flt_Vec) is
    F: File_Type;
  begin
    if FileName="" then
      Plot(Standard_Output,R);
    else
      Open_Append(F,FileName);
      Plot(F,R);
      Close(F);
    end if;
  end Append_Plot;

end Flts.Plotting;
