with Ada.Text_IO;
use Ada.Text_IO;

pragma Elaborate_All (Ada.Text_IO);

generic

  type Flt is digits <>;

package FltStr is

  procedure ValHex(N: in String; R: in out Flt; Rounded: out Boolean);
  function ValHex(N: String) return Flt;                     -- sets Rounded_Last
  function HexStr(R: Flt; Digs: Natural := 0) return String;
  function DecStr(R: Flt; Digs: Natural := 0) return String; -- standard Ada

  package Flt_IO is new Ada.Text_IO.Float_IO(Flt);

  procedure Put(P: in File_Access; R: in Flt; F: in Field := Flt_IO.Default_Fore;
                                              A: in Field := Flt_IO.Default_Aft; E: in Field := Flt_IO.Default_Exp);
  procedure Put(F: in File_Type; R: in Flt; Decimal: in Boolean := False);
  procedure Get(F: in File_Type; R: in out Flt; Decimal: in Boolean := False);
  procedure Write(FileName: in String; R: in Flt; Decimal: in Boolean := False);
  procedure Read(FileName: in String; R: in out Flt; Decimal: in Boolean := False);
  function Prompt(N: String) return Flt; -- caution: input may get rounded
  function GetArg return Flt; -- caution: input may get rounded
  procedure Show1(N: in String; R: in Flt; NewLine: in Boolean := True);
  procedure Show2(N: in String; R1,R2: in Flt; NewLine: in Boolean := True);
  procedure Show3(N: in String; R1,R2,R3: in Flt; NewLine: in Boolean := True);

  Rounded_Last: Boolean := False;

end FltStr;
