with Ada.Text_IO, Ada.Integer_Text_IO, Integer_Subtypes, Integer_Sqrt;
use Ada.Text_IO;

pragma Elaborate_All (Ada.Text_IO,Ada.Integer_Text_IO,Integer_Subtypes,Integer_Sqrt);

package Ints is

  package Int_IO renames Ada.Integer_Text_IO;

  function IMin(I1,I2: Integer) return Integer renames Integer'Min;
  function IMax(I1,I2: Integer) return Integer renames Integer'Max;
  function IMin(I1,I2,I3: Integer) return Integer;
  function IMax(I1,I2,I3: Integer) return Integer;
  function Sign(I: in Integer) return Integer;
  function Choose(ChooseN0: Boolean; N0,N1: Integer) return Integer;
  function IntVal(B: Boolean) return Integer;
  function Binomial(N,M: Positive) return Positive;
  function Convert(I: Integer) return Integer;
  function Sqr(I: Integer) return Integer;
  function Sqrt(N: Natural) return Natural renames Integer_Sqrt;
  function ISqrt(N: Positive) return Natural;
  function GCD(N,D: Integer) return Integer;
  function LCM(M,N: Positive) return Integer;

  procedure Put(P: in File_Access; I: in Integer; Width: in Field := Int_IO.Default_Width);
  procedure Put(F: in File_Type; I: in Integer; Dummy: in Boolean := False);     --- includes New_Line
  procedure Get(F: in File_Type; I: in out Integer; Dummy: in Boolean := False);
  function Read(FileName: in String) return Integer;
  function Prompt(N: String) return Integer;
  procedure Show1(N: in String; I: in Integer; NewLine: in Boolean := True);
  procedure Show2(N: in String; I1,I2: in Integer; NewLine: in Boolean := True);
  function GetArg return Integer;

  type Integer_Access is access all Integer;

  function Put_Value(Ptr: Integer_Access; Val: Integer) return Boolean;

  subtype Parity is Integer_Subtypes.Parity;           -- Integer range 0..1
  subtype OneTwo is Integer_Subtypes.OneTwo;           -- Integer range 1..2
  subtype OneTwoThree is Integer_Subtypes.OneTwoThree; -- Integer range 1..3
  subtype Negative is Integer range Integer'First .. -1;

  type Int_Vec is array(Integer range <>) of Integer;
  type Int_Mat is array(Integer range <>, Integer range <>) of Integer;
  type ParPair is array(OneTwo) of Parity;

end Ints;
