with Logicals, Flts;
use Logicals, Flts;

pragma Elaborate_All (Logicals,Flts);

generic
  
  with function IsSharp(S: Scalar) return Boolean is <>;
  with function Center0(S: Scalar) return Boolean is <>;
  with function Contains0(S: Scalar) return Logical is <>;
  with function Contains(S1,S2: Scalar) return Logical is <>;
  with procedure ToErr(S: in out Scalar) is <>;
  with procedure ToErr(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Center(S: in out Scalar) is <>;
  with procedure Center(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure ModCenter(S: in out Scalar) is <>;
  with procedure ModCenter(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Mult(R: in Flt; S,Tmp: in out Scalar) is <>;
  with procedure Prod(R: in Flt; S1: in Scalar; S2: in out Scalar) is <>;
  with procedure AddProd(R: in Flt; S1: in Scalar; S2,Tmp: in out Scalar) is <>;
  with procedure SubProd(S1,S2: in Scalar; S3,Tmp: in out Scalar) is <>;
  with procedure Div(R: in Flt; S,Tmp: in out Scalar) is <>;
  with procedure Quot(S1: in Scalar; R: in Flt; S2: in out Scalar) is <>;
  
package Matrices.More is
  
  function IsSharp is new MF_BProperty (Scalar,Matrix,IsSharp);
  function Center0 is new MF_BProperty (Scalar,Matrix,Center0);
  function Contains0 is new MF_LProperty (Scalar,Matrix,Contains0);
  function Contains is new MF_LSimilar (Scalar,Matrix,Contains);
  procedure ToErr is new MP_Modify1 (Scalar,Matrix,ToErr);
  procedure ToErr is new MP_Map1 (Scalar,Matrix,ToErr);
  procedure Center is new MP_Modify1 (Scalar,Matrix,Center);
  procedure Center is new MP_Map1 (Scalar,Matrix,Center);
  procedure ModCenter is new MP_Modify1 (Scalar,Matrix,ModCenter);
  procedure ModCenter is new MP_Map1 (Scalar,Matrix,ModCenter);

  procedure Mult(R: in Flt; M: in out Matrix; Tmp: in out Scalar);
  procedure Prod(R: in Flt; M1: in Matrix; M2: in out Matrix);
  procedure AddProd(R: in Flt; M1: in Matrix; M2: in out Matrix; Tmp: in out Scalar);
  procedure AddProd(S: in Scalar; M1: in Matrix; M2: in out Matrix; Tmp: in out Scalar);
  procedure SubProd(S: in Scalar; M1: in Matrix; M2: in out Matrix; Tmp: in out Scalar);
  procedure Div(R: in Flt; M: in out Matrix; Tmp: in out Scalar);
  procedure Quot(M1: in Matrix; R: in Flt; M2: in out Matrix);
  
end Matrices.More;
