with Flts, Globals, Params.Names, Strings, Reps, Ints, Polynoms;
use Flts, Globals, Params, Strings, Reps, Ints;
with Params.Names, Matrices, Vectors, ScalVectors, Taylors1.Cheb;

pragma Elaborate_All (Flts,Globals,Params,Strings,Reps);
pragma Elaborate_All (Params.Names,Matrices,Vectors,ScalVectors, Taylors1.Cheb);

procedure Plots is

   Sol: Natural := GetArg;
   Lambda: Flt := GetArg;

   P: Param := PList(Sol);
   package PN is new Params.Names(P => P, Trunc => True);
   use PN;

   subtype NumScalar is Rep;
   package NSV is new Vectors (Component => NumScalar);
   package NSM is new Matrices (Scalar => NumScalar);
   package NPoly is new Polynoms (Scalar => NumScalar, SV => NSV);
   package NSSV is new ScalVectors (Scalar => NumScalar, SM => NSM, SV => NSV);

   package NTay is new Taylors1(PDeg => PDeg, Scalar => NumScalar, SM => NSM, SV => NSV, SP => NPoly);
   package NTC is new NTay.Cheb(CDeg => CDeg, RadC => RadC);

   use NTC;

   F: Traj;
   N: Positive := 100;
   S,T: NTC.TScalar;
   DT: Flt := Two/Flt(N);
   U: NSV.Vector(0..N);

   procedure Plot(L: in Positive) is
   begin
      for I in 0..N loop
         T := NTay.Scal(Flt(I)*DT-One);
         NTC.TayChebs.Val(F(L),T,S);
         U(I) := NTay.Val(S,Scal(Lambda));
      end loop;
   end Plot;

begin

   Read(Input_Dir & Fix_Name,F);
   Show("",P);
   Plot(1);
   NSV.Write(Pic_Dir & Plot_Name & ".y",U,True);
   Plot(2);
   NSV.Write(Pic_Dir & Plot_Name & ".theta",U,True);
   Plot(3);
   NSV.Write(Pic_Dir & Plot_Name & ".d1",U,True);
   Plot(4);
   NSV.Write(Pic_Dir & Plot_Name & ".d2",U,True);

end Plots;
