
package body Pooling is

  procedure Initialize(C: in out Controlled_LD_Pointer) is
    --- used during declarations that do not assign values
  begin
    Pool.Allocate(C.L);
  end Initialize;

  --- An assignment dest := source triggers
  --- (1) finalize(dest)
  --- (2) bitwise copy of source into dest
  --- (3) adjust(dest)

  procedure Adjust(C: in out Controlled_LD_Pointer) is
    L1: LD_Pointer renames C.L;
    L0: constant LD_Pointer := L1;
  begin
    Pool.Allocate(L1);
    CP(L0.all.Data,L1.all.Data);
  end Adjust;

  procedure Finalize(C: in out Controlled_LD_Pointer) is
  begin
    Pool.Recycle(C.L);
  end Finalize;

end Pooling;
