
package body QPowers is

  procedure QPower(Q: in Rational; S1: in Scalar; S2: in out Scalar) is
    N: constant Integer := INum(Q);
    D: constant Integer := IDen(Q);
  begin
    if D=1 then IPower(N,S1,S2); return; end if;
    if N=1 then Root(D,S1,S2); return; end if;
    declare
      S: Scalar;
    begin
      if D<5 then           -- ad hoc
        Root(D,S1,S);
        IPower(N,S,S2);
      else
        Log(S1,S);
        Mult(Flt(N),S,S2);  -- S2 is Tmp
        Div(Flt(D),S,S2);   -- S2 is Tmp
        Exp(S,S2);
      end if;
    end;
  end QPower;

end QPowers;
