with Ada.Text_IO;
use Ada.Text_IO;

pragma Elaborate_All(Ada.Text_IO);

package Strings is

  procedure Put(P: in File_Access; N: in String);
  procedure Put(F: in File_Type; N: in Boolean);
  procedure Get(F: in File_Type; N: out Boolean);
  procedure Put_Line(P: in File_Access; N: in String);
  procedure New_Line(P: in File_Access);
  procedure Flush(P: in File_Access);

  function GetArg return Character;
  function GetArg return String;
  function GetArg return Boolean;
  function Get_Next_Line(F: File_Type) return String;
  function Prompt(N: String) return String;
  function Choose(ChooseC0: Boolean; C0,C1: Character) return Character;
  function Choose(ChooseS0: Boolean; S0,S1: String) return String;
  function Val(C: Character; VMax: Positive) return Natural;
  function Value(S: String; Base: Positive) return Integer;
  function Strip0(I: Natural; Base: Positive := 10) return Natural;
  function Width(I: Integer; Base: Positive := 10) return Positive;
  function Image(I: Integer; Base: Positive; ShowPlus: Boolean) return String;
  function Strng(I: Integer; W: Positive) return String;
  function Strng(I: Integer) return String;
  function Strng0(I: Natural; W: Positive) return String;
  function RankStrng(I: Natural; W: Positive) return String;
  procedure Show0(NewLine: in Boolean := True);
  procedure Show0(N: in String; NewLine: in Boolean := True);
  function Show0(N: in String) return String;
  procedure Show1(N: in String; B: in Boolean; NewLine: in Boolean := True);

  UpDig: constant array(0..35) of Character := "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  LoDig: constant array(0..35) of Character := "0123456789abcdefghijklmnopqrstuvwxyz";

  pragma Inline (Put,Put_Line,New_Line,Flush);

end Strings;
