with ScalVectors, Linear, Linear.Contr;

pragma Elaborate_All (ScalVectors,Linear.Contr);

generic

   T2C,T2W: in Radius;
   Mat_PackSize: in Positive;
   with package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

package Taylors1.Cheb.Fix is

   subtype SMatrix is SM.Matrix;

   function Energy(F: Traj) return TScalar;
   procedure DerP(F: in Traj; M: in out SMT.Matrix);
   procedure GVar(DThCoeff,DTheta1,DTheta2: in TayCheb; DGTheta1,DGTheta2: in out TayCheb);
   procedure GMap(F: in Traj; GF: in out Traj);
   procedure Aux(Y,Theta: in TayCheb; Y2,SinTheta,SqrSinTheta,Sin2Theta,Sin4Theta,Cos2Theta,
                                        Cos4Theta,SixYplus2,EightYplus6,DThCoeff: in out TayCheb);
   procedure DGMap(Y,Theta,Y2,SinTheta,SqrSinTheta,Sin2Theta,Sin4Theta,Cos2Theta,
                   Cos4Theta,SixYplus2,EightYplus6,DThCoeff: in TayCheb; H: in Traj; DGH: in out Traj);
   procedure DContrNorm(M: in SMatrix; F: in Traj; PackSize: in Positive; R: out Radius);
   procedure ContrFix(M: in SMatrix; PackSize: in Positive; F: in out Traj);

   package SV_Ops renames SSV.SV_Ops;
   package Lin is new Linear (Scalar => Scalar, SM => SM, SV => SV, Fun => Traj,
                              Mode => TrajMode, Modes => TrajModes);
   package Lin_Contr is new Lin.Contr (SSV => SSV);

   --- numerical
   procedure DerMatrix(F: in Traj; M: in out SMatrix);
   procedure ContrMatrix(F: in Traj; M: in out SMatrix);
   procedure ApproxFix(F: in out Traj; M: in out SMatrix; Eps: in Radius := Zero);
   procedure IterContr(F: in out Traj; M: in out SMatrix);

   QC: TrajModes := Make(RadC,Mat_PackSize,True,True);   --- Simple and no Err modes
   subtype QC_Vector is SV.Vector(QC'Range);
   subtype QC_Matrix is SMatrix(QC'Range,QC'Range);

   MOmega2:    TScalar  := Interval(-T2C,T2W);
   M34Omega2:  TScalar  := (Three*Quarter)*MOmega2;
   IVFlt:      Radius   := Two**8;
   IV:         TScalar  := (One/IVFlt)*TOne;
   MFac:       TScalar  := IVFlt*TOne;

end Taylors1.Cheb.Fix;
