with Flts, Globals, Params, Strings, Reps.Balls, Ints;
use Flts, Globals, Params, Strings, Reps, Reps.Balls, Ints;
with Params, Matrices, Vectors, ScalVectors, Polynoms, Taylors1.Cheb, Taylors2.Cheb;

pragma Elaborate_All (Flts,Globals,Params,Strings,Reps);
pragma Elaborate_All (Params,Matrices,Vectors,ScalVectors, Polynoms, Taylors1.Cheb, Taylors2.Cheb);

procedure Check_Branch is

   subtype Scalar is Ball;
   PDeg0:  Integer  := 0;
   PDeg1: constant Positive := 35;
   PDeg2: constant Positive := 35;
   CDeg:  constant Positive := 100;
   RadC:  constant Radius   := Flt(5)/Flt(4);

   package SV is new Vectors (Component => Scalar);
   package SM is new Matrices (Scalar => Scalar);
   package Poly is new Polynoms (Scalar => Scalar, SV => SV);
   package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

   package TayA is new Taylors1(PDeg => PDeg0, Scalar => Scalar, SM => SM, SV => SV, SP => Poly);
   package TCA is new TayA.Cheb(CDeg => CDeg, RadC => RadC);

   package TayB is new Taylors1(PDeg => PDeg1, Scalar => Scalar, SM => SM, SV => SV, SP => Poly);
   package TCB is new TayB.Cheb(CDeg => CDeg, RadC => RadC);

   package TayC is new Taylors2(PDeg => PDeg2, Scalar => Scalar, SM => SM, SV => SV);
   package TCC is new TayC.Cheb(CDeg => CDeg, RadC => RadC);

   subtype Freq is TCA.Freq;
   A1,A2: TCA.Traj;
   B1,B2: TCB.Traj;
   C1   : TCC.Traj;
   R1,R2,Diff: Radius;
   OK: Boolean := True;
   Names: array(1..30) of String(1..4) := ("PL09","PL08","PL07","PL06","PL05","PL04","PL03","PL02","PL01",
                                           "PR01","PR02","PR03","PR04","PR05","PR06","PR07","PR08",
                                           "SE01","SE02","SE03","SE04","SE05","SE06","SE07","SE08",
                                           "SE09","SE10","SE11","SE12","SE13");
   ScalPlus : constant Scalar := Scal( 1);
   ScalMinus: constant Scalar := Scal(-1);
   ScalZero:  constant Scalar := Scal( 0);
   Lambda: Flt;

   procedure Eval is
   begin
      TCA.TayChebVecs.SetZero(A1);
      TCA.TayChebVecs.SetZero(A2);
      for I in 1..2 loop
         for K in Freq loop
            TayB.Val(B1(I).C(K),ScalPlus,A1(I).C(K).C(0));
            TayB.Val(B2(I).C(K),ScalMinus,A2(I).C(K).C(0));
         end loop;
      end loop;
   end Eval;

begin

   TCC.Read(Input_Dir & "BIF1-fix",C1);
   TCB.Read(Input_Dir & "PL01-fix",B2);
   TCA.TayChebVecs.SetZero(A1);
   TCA.TayChebVecs.SetZero(A2);
   for I in 1..2 loop
      for K in Freq loop
         TayC.Val(C1(I).C(K),ScalPlus,ScalZero,A1(I).C(K).C(0));
         TayB.Val(B2(I).C(K),ScalPlus,A2(I).C(K).C(0));
      end loop;
      R1 := C1(I).E(0);
      R2 := B2(I).E(0);
      TCA.TayChebs.Sub(A1(I),A2(I));
      Diff := TCA.TayChebs.MaxNorm(A2(I));
      if abs(R2-R1)>Diff then Show1("PL-BIF1 Match ok: ",I); else Show1("No match: ",I); OK := False; end if;
   end loop;

   TCB.Read(Input_Dir & "PR01-fix",B2);
   TCA.TayChebVecs.SetZero(A1);
   TCA.TayChebVecs.SetZero(A2);
   for I in 1..2 loop
      for K in Freq loop
         TayC.Val(C1(I).C(K),ScalMinus,ScalZero,A1(I).C(K).C(0));
         TayB.Val(B2(I).C(K),ScalMinus,A2(I).C(K).C(0));
      end loop;
      R1 := C1(I).E(0);
      R2 := B2(I).E(0);
      TCA.TayChebs.Sub(A1(I),A2(I));
      Diff := TCA.TayChebs.MaxNorm(A2(I));
      if abs(R2-R1)>Diff then Show1("PR-BIF1 Match ok: ",I); else Show1("No match: ",I); OK := False; end if;
   end loop;

   TCB.Read(Input_Dir & "SE01-fix",B2);
   TCA.TayChebVecs.SetZero(A1);
   TCA.TayChebVecs.SetZero(A2);
   Lambda := -Flt(5019635)*Half**23;
   for I in 1..2 loop
      for K in Freq loop
         TayC.Val(C1(I).C(K),ScalMinus,Scal(Lambda),A1(I).C(K).C(0));
         TayB.Val(B2(I).C(K),ScalMinus,A2(I).C(K).C(0));
      end loop;
      R1 := C1(I).E(0);
      R2 := B2(I).E(0);
      TCA.TayChebs.Sub(A1(I),A2(I));
      Diff := TCA.TayChebs.MaxNorm(A2(I));
      if abs(R2-R1)>Diff then Show1("SE-BIF1 Match ok: ",I); else Show1("No match: ",I); OK := False; end if;
   end loop;

   TCC.Read(Input_Dir & "BIF2-fix",C1);
   TCB.Read(Input_Dir & "PL09-fix",B2);
   TCA.TayChebVecs.SetZero(A1);
   TCA.TayChebVecs.SetZero(A2);
   Lambda := Flt(893870920)*Half**30;
     for I in 1..2 loop
      for K in Freq loop
         TayC.Val(C1(I).C(K),Scal(-Flt(460175067)*Half**30),Scal(Lambda),A1(I).C(K).C(0));
         TayB.Val(B2(I).C(K),ScalMinus,A2(I).C(K).C(0));
      end loop;
      R1 := C1(I).E(0);
      R2 := B2(I).E(0);
      TCA.TayChebs.Sub(A1(I),A2(I));
      Diff := TCA.TayChebs.MaxNorm(A2(I));
      if abs(R2-R1)>Diff then Show1("PL-BIF2 Match ok: ",I); else Show1("No match: ",I); OK := False; end if;
   end loop;

   for L in 1..29 loop
      if L/=9 and L/=17 then
         TCB.Read(Input_Dir & Names(L) & "-fix",B1);
         TCB.Read(Input_Dir & Names(L+1) & "-fix",B2);
         Eval;
         for I in 1..2 loop
            R1 := B1(I).E(0);
            R2 := B2(I).E(0);
            TCA.TayChebs.Sub(A1(I),A2(I));
            Diff := TCA.TayChebs.MaxNorm(A2(I));
            if abs(R2-R1)>Diff then Show2("Match ok: ",L,I); else Show2("No match: ",L,I); OK := False; end if;
         end loop;
      end if;
   end loop;

   if OK then Show0("all matches OK"); end if;

end Check_Branch;
