with Flts, Newton;
use Flts;

pragma Elaborate_all (Flts,Newton);

generic

  Numeric: in Boolean;

  type Scalar is private;

  with procedure Copy(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Neg(S: in out Scalar) is <>;
  with procedure Add(I: in Integer; S: in out Scalar) is <>;
  with procedure Add(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Sub(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Sum(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with procedure Mult(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Prod(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with procedure Quot(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with procedure Center(S: in out Scalar) is <>;
  with function MaxNorm(S: Scalar) return Radius is <>;
  with procedure BallAt0(R: in Flt; S: in out Scalar) is <>;

package ImproveRoots is --- find zeros of functions

  package ScalNewton is new Newton (Numeric => Numeric, Scalar => Scalar, Operator => Scalar);

  procedure ImproveRoot2(B,C: in Scalar; U: in out Scalar; Steps: in Natural := 64);
  procedure ImproveRoots2(B,C: in Scalar; U1,U2: in out Scalar; Steps: in Natural := 64);
  procedure ImproveRoot3(B,C,D: in Scalar; U: in out Scalar; Steps: in Natural := 64);
  procedure ImproveRoots3(B,C,D: in Scalar; U1,U2: in out Scalar; Steps: in Natural := 64);

end ImproveRoots;
