with Ada.Finalization, Recycling;
use Ada.Finalization;

generic

  type Item is private;

  with procedure CP(I1: in Item; I2: in out Item) is <>; -- copy

package Pooling is

  package Alloc is new Recycling (Item => Item);
  use Alloc;

  PO: Controlled_Protected_Data;
  Pool: Protected_Data renames PO.P;

  type Controlled_LD_Pointer is new Controlled with
    record
      L: LD_Pointer := null;
    end record;

  overriding procedure Initialize(C: in out Controlled_LD_Pointer);
  overriding procedure Adjust(C: in out Controlled_LD_Pointer);
  overriding procedure Finalize(C: in out Controlled_LD_Pointer);

end Pooling;
