with Chebs;

pragma Elaborate_All (Chebs);

generic

   CDeg: in Positive;       ---- Cheb degree
   RadC: in Radius;

   with procedure IPower(I: in Integer; S1: in Scalar; S2,Tmp: in out Scalar) is <>;
   with procedure DiskAt0(F: in Flt; S: in out Scalar) is <>;
   with function DiskAt0(F: Flt) return Scalar is <>;
   with procedure Free_Cache(S: in Scalar) is <>;

package Taylors2.Cheb is

   subtype TScalar is Taylor2;
   package SVT is new Vectors (Component => TScalar);
   package SMT is new Matrices (Scalar => TScalar);

   package TayChebs is new Chebs (CDeg => CDeg, RadC => RadC, Scalar => TScalar, SV => SVT, SM => SMT);
   use TayChebs;

   subtype TayCheb is TayChebs.Cheb;
   package TayChebVecs is new Vectors (Component => TayCheb);
   use TayChebVecs;

   Dim: constant Positive := 2;
   subtype Freq is TayChebs.Freq;
   subtype EFreq is TayChebs.EFreq;
   subtype Index is Positive range 1 .. Dim;
   subtype Traj is TayChebVecs.Vector(Index);

   type TrajMode is       --- a unit coeff or unit error
      record
         R: Radius;            --- domain parameter
         I: Index;             --- vector index
         J: EFreq;             --- Cheb index
         L1: Power;            --- Taylor index
         L2: Power;            --- Taylor index
         Err: Boolean;         --- Cheb error
         Simple: Boolean;      --- Extract used only in Linear.Contr.Prod
      end record;

   procedure Center(F: in out Traj);
   procedure Mult(S: in TScalar; F: in out Traj);
   procedure Prod(S: in TScalar; F: in Traj; G: in out Traj);
   procedure AddProd(S: in TScalar; F: in Traj; G: in out Traj);
   function MaxNorm(F: Traj) return Radius;
   procedure AddBall(R: in Radius; F: in out Traj);
   procedure Read(FileName: in String; P: in out Traj; Decimal: in Boolean := False);
   procedure Write(FileName: in String; P: in Traj; Decimal: in Boolean := False);
   procedure Norm(M: in TrajMode; S: in out Scalar);
   procedure MaxNorm(M: in TrajMode; S: out Radius);
   procedure Assign(M: in TrajMode; Q: in out Traj);
   procedure AddProd(M: in TrajMode; S: in Scalar; Q: in out Traj; Check: in Boolean);
   procedure Extract(M: in TrajMode; Q: in out Traj; S: in out Scalar; Check: in Boolean);
   procedure Show(M: in TrajMode);

   type TrajModes is array (Positive range <>) of TrajMode; -- should start with index 1

   function Make(RP: Radius; Siz: Positive; Simple,Trunc: Boolean) return TrajModes;

   TZero: constant TScalar := Scal(0);
   TOne:  constant TScalar := Scal(1);

private

   --- modes etc
   procedure Extract_Coeff(M: in TrajMode; Q: in out Traj; S: in out Scalar); --- used only in ContrFix
   procedure Fail(M: in TrajMode; Q: in out Traj; S: in out Scalar);
   procedure Extract_ErrorF(M: in TrajMode; Q: in out Traj; S: in out Scalar) renames Fail;
   procedure Extract_ErrorT(M: in TrajMode; Q: in out Traj; S: in out Scalar) renames Fail;
   function SameType(M1,M2: TrajMode) return Boolean;

   Tiny: constant Radius := Flt'Scaling(One,Flt'Machine_Emin);

end Taylors2.Cheb;
