with Flts, Globals, Params.Names, Strings, Reps.Balls, Ints, Polynoms;
use Flts, Globals, Params, Strings, Reps, Reps.Balls, Ints;
with Params.Names, Matrices, Vectors, ScalVectors, Taylors1.Cheb.Fix;

pragma Elaborate_All (Flts,Globals,Params,Strings,Reps);
pragma Elaborate_All (Params.Names,Matrices,Vectors,ScalVectors,Taylors1.Cheb.Fix);

procedure Check_Fixpt(P: in Param) is

   package PN is new Params.Names(P => P, Trunc => False);
   use PN;

   subtype NumScalar is Rep;
   package NSV is new Vectors (Component => NumScalar);
   package NSM is new Matrices (Scalar => NumScalar);
   package NPoly is new Polynoms (Scalar => NumScalar, SV => NSV);
   package NSSV is new ScalVectors (Scalar => NumScalar, SM => NSM, SV => NSV);

   package NTay is new Taylors1(PDeg => PDeg, Scalar => NumScalar, SM => NSM, SV => NSV, SP => NPoly);
   package NTC is new NTay.Cheb(CDeg => CDeg, RadC => RadC);
   package NFix is new NTC.Fix(T2C => T2C, T2W => T2W, SSV => NSSV, Mat_PackSize => Mat_PackSize);

   subtype Scalar is Ball;
   package SV is new Vectors (Component => Scalar);
   package SM is new Matrices (Scalar => Scalar);
   package Poly is new Polynoms (Scalar => Scalar, SV => SV);
   package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

   package Tay is new Taylors1(PDeg => PDeg, Scalar => Scalar, SM => SM, SV => SV, SP => Poly);
   package TC is new Tay.Cheb(CDeg => CDeg, RadC => RadC);
   package Fix is new TC.Fix(T2C => T2C, T2W => T2W, SSV => SSV, Mat_PackSize => Mat_PackSize);

   Epsilon: constant Radius := 1.0e-15;

   NF: NTC.Traj;
   NM: NFix.QC_Matrix;
   F: TC.Traj;
   M: Fix.QC_Matrix;
   NDP: NTC.SMT.Matrix(1..2,1..2);
--   FHat: NTC.TayCheb;

begin

   Show("",P);
   NTC.Read(Input_Dir & Fix_Name & ".approx",NF);
   --  NTC.TayChebs.Read(Input_Dir & "BIF2.FHat",FHat);
   --  NTC.TayChebs.Mult(Flt(1.0),FHat);
   --  NTC.TayChebs.Add(FHat,NF(2));
   NFix.ApproxFix(NF,NM,Epsilon);
   Show1("norm y",NTC.TayChebs.MaxNorm(NF(1)));
   Show1("norm theta",NTC.TayChebs.MaxNorm(NF(2)));
   NTC.Write(Output_Dir & Fix_Name & ".approx",NF);
   NFix.DerP(NF,NDP);
   Show1("det(DP):",NDP(1,1).C(0)*NDP(2,2).C(0)-NDP(2,1).C(0)*NDP(1,2).C(0));
   Show1("energy:",NTay.Approx(NFix.Energy(NF)));
   if Contr_PackSize > 0 then
      for I in NM'Range(1) loop
         for J in NM'Range(2) loop
            M(I,J) := Scal(Approx(NM(I,J)));
         end loop;
      end loop;

      TC.Read(Input_Dir & Fix_Name & ".approx",F);
      Fix.ContrFix(M,Contr_PackSize,F);
      TC.Write(Output_Dir & Fix_Name,F);

      declare
         use Tay;
         DP: TC.SMT.Matrix(1..2,1..2);
         Det,Dis: Taylor1;
         IDis,SDis: Flt;
      begin
         Fix.DerP(F,DP);
         Det := DP(1,1)*DP(2,2)-DP(2,1)*DP(1,2);
         Dis := DP(1,1)*DP(1,1)+Four*DP(1,2)*DP(2,1)-Two*DP(1,1)*DP(2,2)+DP(2,2)*DP(2,2);
         if PDeg=0 then Dis.F := FConst; end if;
         IDis := Inf(Dis);
         SDis := Sup(Dis);
         Show2("dis",IDis,SDis);
         Show2("det(DP):",Inf(Det),Sup(Det));
         if IDis>Zero then
            Show0("unstable");
         elsif SDis<Zero then
            Show0("stable");
         end if;
      end;
   end if;

end Check_Fixpt;
