
generic

  type Flt is digits <>;
  type Real is private;
  type Vector is array (Integer range <>) of Real;
  type Matrix is array (Integer range <>, Integer range <>) of Real;
  type Pivot is array(Integer range <>) of Integer;

  with function Scal(R: Flt) return Real is <>;
  with function Approx(S: Real) return Flt is <>;
  with procedure Swap(S1,S2: in out Real) is <>;
  with function "<"(S1,S2: Real) return Boolean is <>;
  with function "-"(S: Real) return Real is <>;
  with function "+"(S1,S2: Real) return Real is <>;
  with function "-"(S1,S2: Real) return Real is <>;
  with function "*"(S1,S2: Real) return Real is <>;
  with function "/"(S1,S2: Real) return Real is <>;
  with function "abs"(S: Real) return Real is <>;
  with function Sqrt(S: Real) return Real is <>;

package EisPack2 is -- adapted from eispack

  procedure cbal(n: in Integer; ar,ai: in out Matrix; low,igh: out Integer; scale: in out Vector);
  procedure cbabk2(n,low,igh,m: in Integer; scale: in Vector; zr,zi: in out Matrix);
  procedure comhes(n,low,igh: in Integer; ar,ai: in out Matrix; int: out Pivot);
  procedure comlr2(n,low,igh: in Integer; int: in Pivot; hr,hi: in out Matrix;
                   wr,wi: in out Vector; zr,zi: in out Matrix; ierr: out Integer);

private

  procedure cdiv(ar,ai,br,bi: in Real; cr,ci: in out Real);
  procedure csroot(xr,xi: in Real; yr,yi: in out Real);

  Zero_Real: constant Real := Scal(0.00);
  One_Real:  constant Real := Scal(1.00);
  Two_Real:  constant Real := Scal(2.00);
  Half_Real: constant Real := Scal(0.50);
  Small:     constant Real := Scal(0.01);
  Near_One:  constant Real := Scal(0.95);

end EisPack2;
