
package Body Logicals is

  function Value(Arg: Boolean) return Logical is
  begin
    if Arg then return True; end if;
    return False;
  end Value;

  function "not"(Arg: Logical) return Logical is
  begin
    case Arg is
      when False => return True;
      when True => return False;
      when others => return Uncertain;
    end case;
  end "not";

  function "and"(Left,Right: Logical) return Logical is
  begin
    if Left=False or else Right=False then
      return False;
    elsif Left=Uncertain or else Right=Uncertain then
      return Uncertain;
    else
      return True;
    end if;
  end "and";

  function "and"(Left: Boolean; Right: Logical) return Logical is
  begin
    if Left=False or else Right=False then
      return False;
    elsif Right=Uncertain then
      return Uncertain;
    else
      return True;
    end if;
  end "and";

  function "and"(Left: Logical; Right: Boolean) return Logical is
  begin
    if Left=False or else Right=False then
      return False;
    elsif Left=Uncertain then
      return Uncertain;
    else
      return True;
    end if;
  end "and";

  function "or"(Left,Right: Logical) return Logical is
  begin
    if Left=True or else Right=True then
      return True;
    elsif Left=Uncertain or else Right=Uncertain then
      return Uncertain;
    else
      return False;
    end if;
  end "or";

  function "or"(Left: Boolean; Right: Logical) return Logical is
  begin
    if Left or else Right=True then
      return True;
    elsif Right=Uncertain then
      return Uncertain;
    else
      return False;
    end if;
  end "or";

  function "or"(Left: Logical; Right: Boolean) return Logical is
  begin
    if Left=True or else Right then
      return True;
    elsif Left=Uncertain then
      return Uncertain;
    else
      return False;
    end if;
  end "or";

  function "xor" (Left,Right: Logical) return Logical is
  begin
    if Left=Uncertain or else Right=Uncertain then
      return Uncertain;
    elsif Left=Right then
      return False;
    else
      return True;
    end if;
  end "xor";

  function "xor"(Left: Boolean; Right: Logical) return Logical is
  begin
    if Left then
      return not Right;
    else
      return Right;
    end if;
  end "xor";

  function "xor"(Left: Logical; Right: Boolean) return Logical is
  begin
    if Right then
      return not Left;
    else
      return Left;
    end if;
  end "xor";

end Logicals;
