with Flts;
use Flts;

pragma Elaborate_All (Flts);

package Params is

   type Param is
      record
         Prefix: String(1..4);    -- name
         T2C:  Radius;
         T2W:  Radius;
         PDeg:  Natural;
         CDeg:  Natural;
         RadC:  Radius;
         Mat_PackSize: Positive;  -- pack size for matrix used in Contr
         Contr_PackSize: Natural; -- used in proof (use 0 for purely numeric solution)
      end record;

   ------------------------------------------------------------   approximate value

   PL01: constant Param := (Prefix => "PL01",
                            T2C => Flt(15643)*Half**12,    ----    3.81909
                            T2W => Half**10,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PL02: constant Param := (Prefix => "PL02",
                            T2C => Flt(15655)*Half**12,    ----    3.82202
                            T2W => Half**9,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PL03: constant Param := (Prefix => "PL03",
                            T2C => Flt(15727)*Half**12,    ----    3.8396
                            T2W => Half**6,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PL04: constant Param := (Prefix => "PL04",
                            T2C => Flt(16047)*Half**12,    ----    3.91772
                            T2W => Half**4,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PL05: constant Param := (Prefix => "PL05",
                            T2C => Flt(16815)*Half**12,    ----    4.10522
                            T2W => Half**3,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 80);

   PL06: constant Param := (Prefix => "PL06",
                            T2C => Flt(18351)*Half**12,    ----    4.48022
                            T2W => Half**2,
                            PDeg => 20,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 80);

   PL07: constant Param := (Prefix => "PL07",
                            T2C => Flt(19735)*Half**12,    ----    4.81812
                            T2W => Flt(360)*Half**12,
                            PDeg => 35,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PL08: constant Param := (Prefix => "PL08",
                            T2C => Flt(20137)*Half**12,    ----    4.91626
                            T2W => Flt(42)*Half**12,
                            PDeg => 15,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 80);

   PL09: constant Param := (Prefix => "PL09",
                            T2C => Flt(20200)*Half**12,    ----    4.93164
                            T2W => Flt(21)*Half**12,
                            PDeg => 30,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 60,
                            Contr_Packsize => 80);

   PL10: constant Param := (Prefix => "PL10",
                            T2C => Flt(20221)*Half**12,    ----    4.93677
                            T2W => Zero,
                            PDeg => 0,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 20,
                            Contr_Packsize => 30);

   PR01: constant Param := (Prefix => "PR01",
                            T2C => Flt(15603)*Half**12,    ----    3.80933
                            T2W => Half**10,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PR02: constant Param := (Prefix => "PR02",
                            T2C => Flt(15591)*Half**12,    ----    3.8064
                            T2W => Half**9,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PR03: constant Param := (Prefix => "PR03",
                            T2C => Flt(15551)*Half**12,    ----    3.79663
                            T2W => Half**7,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PR04: constant Param := (Prefix => "PR04",
                            T2C => Flt(15391)*Half**12,    ----    3.75757
                            T2W => Half**5,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   PR05: constant Param := (Prefix => "PR05",
                            T2C => Flt(14751)*Half**12,    ----    3.60132
                            T2W => Half**3,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 44,
                            Contr_Packsize => 80);

   PR06: constant Param := (Prefix => "PR06",
                            T2C => Flt(13215)*Half**12,    ----    3.22632
                            T2W => Half**2,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 44,
                            Contr_Packsize => 80);

   PR07: constant Param := (Prefix => "PR07",
                            T2C => Flt(11167)*Half**12,    ----    3.272632
                            T2W => Half**2,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 44,
                            Contr_Packsize => 80);

   PR08: constant Param := (Prefix => "PR08",
                            T2C => Flt(9119)*Half**12,    ----    2.22632
                            T2W => Half**2,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 44,
                            Contr_Packsize => 80);

   SE01: constant Param := (Prefix => "SE01",
                            T2C => Flt(15603)*Half**12,    ----    3.80933
                            T2W => Half**10,
                            PDeg => 10,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 80);

   SE02: constant Param := (Prefix => "SE02",
                            T2C => Flt(15591)*Half**12,    ----    3.8064
                            T2W => Half**9,
                            PDeg => 10,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE03: constant Param := (Prefix => "SE03",
                            T2C => Flt(15567)*Half**12,    ----    3.80054
                            T2W => Half**8,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 60);

   SE04: constant Param := (Prefix => "SE04",
                            T2C => Flt(15519)*Half**12,    ----    3.78882
                            T2W => Half**7,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE05: constant Param := (Prefix => "SE05",
                            T2C => Flt(15423)*Half**12,    ----    3.76538
                            T2W => Half**6,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE06: constant Param := (Prefix => "SE06",
                            T2C => Flt(15231)*Half**12,    ----    3.71851
                            T2W => Half**5,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE07: constant Param := (Prefix => "SE07",
                            T2C => Flt(14847)*Half**12,    ----    3.62476
                            T2W => Half**4,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE08: constant Param := (Prefix => "SE08",
                            T2C => Flt(14079)*Half**12,    ----    3.43726
                            T2W => Half**3,
                            PDeg => 12,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE09: constant Param := (Prefix => "SE09",
                            T2C => Flt(12543)*Half**12,    ----    3.06226
                            T2W => Half**2,
                            PDeg => 20,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 36,
                            Contr_Packsize => 60);

   SE10: constant Param := (Prefix => "SE10",
                            T2C => Flt(11007)*Half**12,    ----    2.68726
                            T2W => Half**3,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 60);

   SE11: constant Param := (Prefix => "SE11",
                            T2C => Flt(9983)*Half**12,    ----    2.43726
                            T2W => Half**3,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 60);

   SE12: constant Param := (Prefix => "SE12",
                            T2C => Flt(8959)*Half**12,    ----    2.18726
                            T2W => Half**3,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 60);

   SE13: constant Param := (Prefix => "SE13",
                            T2C => Flt(7935)*Half**12,    ----    1.93726
                            T2W => Half**3,
                            PDeg => 8,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 60);

   BIF1: constant Param := (Prefix => "BIF1",
                            T2C => Flt(15623)*Half**12,  ----- 3.81421....
                            T2W => Half**8,
                            PDeg => 9,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 30,
                            Contr_Packsize => 90);

   BIF2: constant Param := (Prefix => "BIF2",
                            T2C => Flt(20230)*Half**12,  ----- pi^2/2=4.93481....
                            T2W => Flt(21)*Half**12,
                            PDeg => 35,
                            CDeg => 100,
                            RadC => Flt(5)/Flt(4),
                            Mat_PackSize => 40,
                            Contr_Packsize => 50);

   type Param_List is array(Natural range <>) of Param;

   PList: constant Param_List(1..33) := (PL01,PL02,PL03,PL04,PL05,PL06,PL07,PL08,PL09,PL10,PR01,PR02,PR03,PR04,PR05,PR06,PR07,PR08,SE01,SE02,SE03,SE04,SE05,SE06,SE07,SE08,SE09,SE10,SE11,SE12,SE13,BIF1,BIF2);

   procedure Show(N: in String; P: in Param);

end Params;
