with Logicals, VGeneric, Flts;
use Logicals, VGeneric, Flts;

pragma Elaborate_All (Logicals,VGeneric,Flts);

generic

  with function IsSharp(S: Scalar) return Boolean is <>;
  with function Center0(S: Scalar) return Boolean is <>;
  with function Contains0(S: Scalar) return Logical is <>;
  with function Contains(S1,S2: Scalar) return Logical is <>;
  with procedure ToErr(S: in out Scalar) is <>;
  with procedure ToErr(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Center(S: in out Scalar) is <>;
  with procedure Center(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure ModCenter(S: in out Scalar) is <>;
  with procedure ModCenter(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Union(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Min(S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Max(S1: in Scalar; S2: in out Scalar) is <>;
  with function Inf(S: Scalar) return Flt is <>;
  with function Sup(S: Scalar) return Flt is <>;
  with procedure Prod(R: in Flt; S1: in Scalar; S2: in out Scalar) is <>;
  with procedure Mult(R: in Flt; S,Tmp: in out Scalar) is <>;
  with procedure Div(R: in Flt; S,Tmp: in out Scalar) is <>;

package Polynoms.More is

  function IsSharp is new VF_BProperty (Scalar,Polynom1,IsSharp);
  function Center0 is new VF_BProperty (Scalar,Polynom1,Center0);
  function Contains0 is new VF_LProperty (Scalar,Polynom1,Contains0);
  function Contains is new VF_LSimilar (Scalar,Polynom1,Contains);
  procedure ToErr is new VP_Modify1 (Scalar,Polynom1,ToErr);
  procedure ToErr is new VP_Map1 (Scalar,Polynom1,ToErr);
  procedure Center is new VP_Modify1 (Scalar,Polynom1,Center);
  procedure Center is new VP_Map1 (Scalar,Polynom1,Center);
  procedure ModCenter is new VP_Modify1 (Scalar,Polynom1,ModCenter);
  procedure ModCenter is new VP_Map1 (Scalar,Polynom1,ModCenter);
  procedure Union is new VP_Map1 (Scalar,Polynom1,Union);

  procedure Min(V: in Polynom1; S: in out Scalar);
  procedure Max(V: in Polynom1; S: in out Scalar);
  function Sup(V: Polynom1) return Flt;
  function Inf(V: Polynom1) return Flt;
  procedure Num_Der(P: in out Polynom1);  -- derivative
  procedure Num_MDer(P: in out Polynom1); -- generator of dilation
  procedure Inv_MDer(P: in out Polynom1; CheckConst: in Boolean := True); -- inverse of MDer

end Polynoms.More;
