
package Protected_Counters is

  protected type Protected_Counter(First: Integer := 0) is
    procedure Reset(N: in Integer);
    procedure Next(N: out Integer);
  private
    Count: Integer := First;
  end Protected_Counter;

  --- not counting main task
  function Reserve_Tasks(NMax: Natural; Allow: Boolean := True) return Natural;
  procedure Free_Tasks(N: in Natural);

private

  protected type Protected_Task_Counter is
    procedure Reserve(N: in out Natural);
    procedure Free(N: in Natural);
  private
    Count: Integer := 1;
  end Protected_Task_Counter;

  Task_Counter: Protected_Task_Counter;

end Protected_Counters;
