
package body Recycling is

  protected body Protected_Data is

    procedure Allocate(L: out LD_Pointer) is
    begin
      if Next=null then
        L := new Linked_Data;
      else
        L := Next;
        Next := Next.all.Link;
      end if;
    end Allocate;

    procedure Recycle(L: in LD_Pointer) is
    begin
      if L /= null then
        L.all.Link := Next;
        Next := L;
      end if;
    end Recycle;

    procedure Free_All is
      L: LD_Pointer;
    begin
      while Next /= null loop
        L := Next;
        Next := Next.all.Link;
        Deallocate(L);
      end loop;
    end Free_All;

  end Protected_Data;

  procedure Finalize(C: in out Controlled_Protected_Data) is
  begin
    C.P.Free_All;
  end Finalize;


end Recycling;
