
package Rounding.FPU is      -- for x87 floating point processor
                             -- 80 bit extended format (64 bit mantissa)
                             -- gnat specific code, but easy to adapt

  procedure Set_Rounding_Mode(M: in Rounding_Mode);
  function Get_Rounding_Mode return Rounding_Mode;
  procedure Default_Rounding_Mode;

private

  type R_Set is mod 2**16;

  R_Nearest:  constant R_Set := 2#0000_0000_0000#;
  R_Down:     constant R_Set := 2#0100_0000_0000#;
  R_Up:       constant R_Set := 2#1000_0000_0000#;
  R_Truncate: constant R_Set := 2#1100_0000_0000#;
  R_Strict:   constant R_Set := 2#0011_0110_0000#;
  R_Relaxed:  constant R_Set := 2#0011_0111_0010#;
  --                                abcd   ef ghij
  --  ab=00  round to nearest
  --  ab=01  round down
  --  ab=10  round up
  --  ab=11  round toward zero
  --  cd=11  64 bit mantissa
  --   e=1   allow rounding (mask exception)
  --   f=0   disallow underflows
  --   g=0   overflows not masked     (exception instead of NaN)
  --   h=0   division by 0 not masked (exception instead of infinity)
  --   i=0   disallow denormalized numbers
  --   j=0   invalid operations not masked

  Current_Rounding_Mode: Rounding_Mode;

end Rounding.FPU;
