
generic

  type Number is Private;  --- real number

  with function Convert(K: Integer) return Number is <>;
  with function "-"(S: Number) return Number is <>;
  with function "+"(S1,S2: Number) return Number is <>;
  with function "-"(S1,S2: Number) return Number is <>;
  with function "*"(S1,S2: Number) return Number is <>;

package AddETC is --- trivial stuff needed to instantiate Matrices

  function IsZero(S: Number) return Boolean;
  function IsReal(Dummy: Number) return Boolean;
  procedure SetZero(S: in out Number);
  procedure Assign(K: in Integer; S: in out Number);
  procedure Copy(S1: in Number; S2: in out Number);
  procedure Swap(S1,S2: in out Number);
  procedure Real_Part(Dummy: in out Number);
  procedure Imag_Part(S: in out Number) renames SetZero;
  procedure Adjoint(S: in out Number) renames Real_Part;
  procedure Adjoint(S1: in Number; S2: in out Number) renames Copy;
  function Adjoint(S: in Number) return Number;

  procedure Neg(S: in out Number);
  procedure Neg(S1: in Number; S2: in out Number);
  procedure Add(S1: in Number; S2: in out Number);
  procedure Sum(S1,S2: in Number; S3: in out Number);
  procedure Sub(S1: in Number; S2: in out Number);
  procedure Diff(S1,S2: in Number; S3: in out Number);
  procedure Mult(S1: in Number; S2: in out Number);
  procedure Prod(S1,S2: in Number; S3: in out Number);
  procedure AddProd(S1,S2: in Number; S3,Dummy: in out Number);
  procedure AddProd(S1,S2: in Number; S3: in out Number);

  pragma Inline_Always (IsZero,SetZero,Assign,Copy,Neg,Add,Sum,Sub,Diff,Mult,Prod,AddProd);

end AddETC;
