with Ada.Text_IO, Ints, Flts, Flt_Vectors;
use Ada.Text_IO, Ints, Flts;

pragma Elaborate_All (Ada.Text_IO,Ints,Flts,Flt_Vectors);

generic

  VLast: in Positive;
  Par: in Parity;
  N: in Positive;      --- determines DT=1/(2*N)

package FltChains is

  subtype FltVec is Flt_Vectors.Vector;
  subtype FltChain is FltVec(0 .. VLast);

  function Component(K: Integer; V: FltVec) return Flt;
  procedure Normalize(V: in out FltVec);
  function Translate(V: FltVec; T: Integer) return FltVec;
  procedure Symmetrize(V: in out FltVec; P: in Parity := Par);
  procedure SumR(V: in FltChain; U: out FltVec);
  procedure TentConv(Width: in Positive; V1: in FltChain; V2: out FltChain);
  function Simple_Random(Decay: Radius) return FltChain;
  procedure PutPlot(F: in File_Type; V: in FltVec);
  procedure AA(Scale: in Positive; V1: in FltChain; V2: out FltChain);

  XFac: Radius := One;
  YFac: Radius := One;

end FltChains;
