with MPFR.Floats.EFuns;
use MPFR.Floats, MPFR.Floats.EFuns;

pragma Elaborate_All (MPFR.Floats.EFuns);

package body Flts.Std.EFuns is --- cheap/slow version using MPFR

  procedure Root(K: in Positive; X,DX: in LLFloat; YL,YU: out LLFloat) is
    S,DS,TL,TU: MPFloat;
  begin
    Val(X,S);
    Val(DX,DS);
    Root(K,S,DS,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end Root;

  function ExpUp(X: LLFloat) return LLFloat is
    S,T: MPFloat;
  begin
    Val(X,S);
    ExpUp(S,T);
    return Upper(T);
  end ExpUp;

  function ExpDown(X: LLFloat) return LLFloat is
    S,T: MPFloat;
  begin
    Val(X,S);
    ExpDown(S,T);
    return Lower(T);
  end ExpDown;

  procedure Exp(X,DX: in LLFloat; YL,YU: out LLFloat) is
    S,DS,TL,TU: MPFloat;
  begin
    Val(X,S);
    Val(DX,DS);
    Exp(S,DS,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end Exp;

  procedure Log(X,DX: in LLFloat; YL,YU: out LLFloat) is
    S,DS,TL,TU: MPFloat;
  begin
    Val(X,S);
    Val(DX,DS);
    Log(S,DS,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end Log;

  procedure ArcCos(X,DX: in LLFloat; YL,YU: out LLFloat) is
    S,DS,TL,TU: MPFloat;
  begin
    Val(X,S);
    Val(DX,DS);
    ArcCos(S,DS,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end ArcCos;

  procedure ArcSin(X,DX: in LLFloat; YL,YU: out LLFloat) is
    S,DS,TL,TU: MPFloat;
  begin
    Val(X,S);
    Val(DX,DS);
    ArcSin(S,DS,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end ArcSin;

  procedure Cos(X: in LLFloat; YL,YU: out LLFloat) is
    S,TL,TU: MPFloat;
  begin
    Val(X,S);
    Cos(S,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end Cos;

  procedure Sin(X: in LLFloat; YL,YU: out LLFloat) is
    S,TL,TU: MPFloat;
  begin
    Val(X,S);
    Sin(S,TL,TU);
    YL := Lower(TL);
    YU := Upper(TU);
  end Sin;

end Flts.Std.EFuns;
