
package body ImproveRoots is

  use ScalNewton;

  procedure ImproveRoot2(B,C: in Scalar; U: in out Scalar; Steps: in Natural := 64) is
    procedure F(X: in Scalar; Y: in out Scalar) is
    begin
      Sum(B,X,Y);
      Mult(X,Y);
      Add(C,Y);  --- Y := C+X*(B+X));
    end F;
    procedure DF(X: in Scalar; Y: in out Scalar) is
    begin
      Sum(B,X,Y);
      Add(X,Y);  --- Y := B+2*X
    end DF;
    procedure Improve is new ImproveZero(F => F, DF => DF);
  begin
    Improve(U,Steps);
  end ImproveRoot2;

  procedure ImproveRoots2(B,C: in Scalar; U1,U2: in out Scalar; Steps: in Natural := 64) is
  begin
    ImproveRoot2(B,C,U1,Steps);
    ImproveRoot2(B,C,U2,Steps);
  end ImproveRoots2;

  procedure ImproveRoot3(B,C,D: in Scalar; U: in out Scalar; Steps: in Natural := 64) is
    procedure F(X: in Scalar; Y: in out Scalar) is
    begin
      Sum(B,X,Y);
      Mult(X,Y);
      Add(C,Y);
      Mult(X,Y);
      Add(D,Y);  --- Y := D+X*(C+X*(B+X));
    end F;
    procedure DF(X: in Scalar; Y: in out Scalar) is
    begin
      Sum(X,X,Y);
      Add(X,Y);
      Add(B,Y);
      Add(B,Y);
      Mult(X,Y);
      Add(C,Y);  --- Y := C+X*(2*B+3*X);
    end DF;
    procedure Improve is new ImproveZero(F => F, DF => DF);
  begin
    Improve(U,Steps);
  end ImproveRoot3;

  procedure ImproveRoots3(B,C,D: in Scalar; U1,U2: in out Scalar; Steps: in Natural := 64) is
  begin
    ImproveRoot3(B,C,D,U1,Steps);
    ImproveRoot3(B,C,D,U2,Steps);
  end ImproveRoots3;

end ImproveRoots;
