with Flts, Scalars, ScalVectors;
use Flts, Scalars;

pragma Elaborate_All (Scalars,ScalVectors);

generic

  with function Info(Dummy: Scalar) return Scalar_Info is <>;
  with procedure Center(S: in out Scalar) is <>;
  with procedure BallAt0(R: in Flt; S: in out Scalar) is <>;
  with procedure Assign(R: in Flt; S: in out Scalar) is <>;
  with procedure SubProd(S1,S2: in Scalar; S3,Tmp: in out Scalar) is <>;
  with function "-"(S: Scalar) return Scalar is <>;
  with procedure Prod(R: in Flt; S1: in Scalar; S2: in out Scalar) is <>;
  with function "*"(R: Flt; S: Scalar) return Scalar is <>;
  with function "*"(S1,S2: Scalar) return Scalar is <>;
  with procedure Inv(S1: in Scalar; S2: in out Scalar) is <>;
  with function Inv(S: Scalar) return Scalar is <>;
  with procedure Quot(S1,S2: in Scalar; S3: in out Scalar) is <>;
  with function Exp(S: Scalar) return Scalar is <>;
  with function Log(S: Scalar) return Scalar is <>;
  with procedure Max(S1: in Scalar; S2: in out Scalar) is <>;
  with function Inf(S: Scalar) return Flt is <>;
  with function Sup(S: Scalar) return Flt is <>;
  with procedure Norm(S1: in Scalar; S2: in out Scalar) is <>;
  with function MaxNorm(S: Scalar) return Radius is <>;
  with procedure Sqrt(S1: in Scalar; S2: in out Scalar) is <>;
  with function Sqrt(S: Scalar) return Scalar is <>;
  with function Scal(R: Flt) return Scalar is <>;
  with function Approx(S: Scalar) return Flt is <>;
  with procedure Mult(R: in Flt; S: in out Scalar) is <>;

  with package SSV is new ScalVectors (Scalar => Scalar, SM => SM, SV => SV);

  with procedure SetZero(F: in out Fun) is <>;
  with function IsZero(F: Fun) return Boolean is  <>;
  with procedure Copy(F1: in Fun; F2: in out Fun) is <>;
  with procedure Add(F1: in Fun; F2: in out Fun) is <>;
  with procedure Sum(F1,F2: in Fun; F3: in out Fun) is <>;
  with procedure Sub(F1: in Fun; F2: in out Fun) is <>;
  with procedure Diff(F1,F2: in Fun; F3: in out Fun) is <>;

package Linear.Contr is

  package SV_Ops renames SSV.SV_Ops;

  procedure Prod(Q: in Modes; M: in SMatrix; F: in Fun; G: in out Fun);
  procedure Contr_Matrix(M: in out SMatrix);

  generic
    with procedure Map(F1: in Fun; F2: in out Fun);
  procedure ContrTmp0(Q: in Modes; M: in SMatrix; F,Tmp1,Tmp2: in out Fun; Err: out Radius);

  generic
    with procedure Map(F1: in Fun; F2: in out Fun);
  procedure Contr0(Q: in Modes; M: in SMatrix; F: in out Fun; Err: out Radius);

  generic
    with procedure Map(F1: in Fun; F2: in out Fun);
  procedure Contr(Q: in Modes; M: in SMatrix; F: in Fun; H: in out Fun; Err: out Radius);

  generic
    with procedure DMap(F1: in Fun; F2: in out Fun);
  procedure DContr(Q: in Modes; M: in SMatrix; H1: in Fun; H2: in out Fun);

end Linear.Contr;
