with Strings;
use Strings ;

pragma Elaborate_All (Strings);

generic

   P: in Param;
   Trunc: in Boolean;

package Params.Names is

   Prefix: String renames P.Prefix;
   T2C:  Radius renames P.T2C;
   T2W:  Radius renames P.T2W;
   PDeg: Natural renames P.PDeg;
   CDeg: Positive renames P.CDeg;
   RadC: Radius renames P.RadC;
   Mat_PackSize: Positive renames P.Mat_PackSize;
   Contr_PackSize: Natural renames P.Contr_PackSize;

   Post: constant String := Choose(Trunc,".approx","");
   Mat_Name: constant String := Prefix & "-mat." & Strng0(Mat_PackSize,3);
   Fix_Name: constant String := Prefix & "-fix" & Post;
   Plot_Name: constant String := Prefix & ".plot";

end Params.Names;
