with Globals;
use Globals;

pragma Elaborate_All (Globals);

package body Polynoms.More is

  procedure Min(V: in Polynom1; S: in out Scalar) is
  begin
    for N in V'Range loop Min(V(N),S); end loop;
  end Min;

  procedure Max(V: in Polynom1; S: in out Scalar) is
  begin
    for N in V'Range loop Max(V(N),S); end loop;
  end Max;

  function Sup(V: Polynom1) return Flt is
    R: Flt := Sup(V(V'First));
  begin
    for N in V'First+1 .. V'Last loop
      R := RMax(Sup(V(N)),R);
    end loop;
    return R;
  end Sup;

  function Inf(V: Polynom1) return Flt is
    R: Flt := Inf(V(V'First));
  begin
    for N in V'First+1 .. V'Last loop
      R := RMin(Inf(V(N)),R);
    end loop;
    return R;
  end Inf;

  procedure Num_Der(P: in out Polynom1) is
  begin
    for N in 1 .. P'Last loop
      Prod(Flt(N),P(N),P(N-1));
    end loop;
    SetZero(P(P'Last));
  end Num_Der;

  procedure Num_MDer(P: in out Polynom1) is
    Tmp: Scalar renames P(0);
  begin
    for N in reverse 2 .. P'Last loop
      Mult(Flt(N),P(N),Tmp);
    end loop;
    SetZero(P(0));
  end Num_MDer;

  procedure Inv_MDer(P: in out Polynom1; CheckConst: in Boolean := True) is
    Tmp: Scalar renames P(0);
  begin
    if CheckConst and then not IsZero(P(0)) then
      raise Undefined with "Polynoms.More.Inv_MDer: nonzero constant";
    end if;
    for N in reverse 2 .. P'Last loop
      Div(Flt(N),P(N),Tmp);
    end loop;
    SetZero(P(0));
  end Inv_MDer;

end Polynoms.More;
