
procedure Quick_Sort(First,Last: in Integer; Items: in out Item_Vector) is

  procedure Sort(L,R: in Integer) is
    M: constant Integer := (L+R)/2;
    I: Integer := L+1;
    J: Integer := R-1;
  begin
    if Items(M)<Items(L) then
      Swap(Items(M),Items(L));
    end if;
    if Items(R)<Items(L) then
      Swap(Items(R),Items(L));
    end if;
    if Items(R)<Items(M) then
      Swap(Items(R),Items(M));
    end if;
    declare
      Pivot: constant Item := Items(M);
    begin
      Swap(Items(M),Items(J));
      if J /= L then
        J := J-1;
      end if;
      loop
        while Items(I)<Pivot loop I := I+1; end loop;
        while Pivot<Items(J) loop J := J-1; end loop;
        exit when I>J;
        if I=R or J=L then return; end if;
        Swap(Items(I),Items(J));
        I := I+1;
        J := J-1;
        exit when I>J;
      end loop;
    end;
    if L<J then Sort(L,J); end if;
    if I<R then Sort(I,R); end if;
  end Sort;

begin
  if First<Last then
    Sort(First,Last);
  end if;
end Quick_Sort;
