with Logicals, Flts;
use Logicals, Flts;

pragma Elaborate_All (Logicals,Flts);

generic

  with function IsSharp(S: Component) return Boolean is <>;
  with function Center0(S: Component) return Boolean is <>;
  with function Contains0(S: Component) return Logical is <>;
  with function Contains(S1,S2: Component) return Logical is <>;
  with procedure ToErr(S: in out Component) is <>;
  with procedure ToErr(S1: in Component; S2: in out Component) is <>;
  with procedure Center(S: in out Component) is <>;
  with procedure Center(S1: in Component; S2: in out Component) is <>;
  with procedure ModCenter(S: in out Component) is <>;
  with procedure ModCenter(S1: in Component; S2: in out Component) is <>;
  with procedure ErrMult(R: in Radius; S: in out Component) is <>;
  with procedure Union(S1: in Component; S2: in out Component) is <>;
  with procedure Intersection(S1: in Component; S2: in out Component; Empty: out Logical) is <>;
  with procedure Min(S1: in Component; S2: in out Component) is <>;
  with procedure Max(S1: in Component; S2: in out Component) is <>;
  with function Inf(S: Component) return Flt is <>;
  with function Sup(S: Component) return Flt is <>;
  with procedure Mult(R: in Flt; S,Tmp: in out Component) is <>;
  with procedure Mult(R: in Flt; S: in out Component) is <>;
  with procedure Prod(R: in Flt; S1: in Component; S2: in out Component) is <>;
  with procedure AddProd(R: in Flt; S1: in Component; S2,Tmp: in out Component) is <>;
  with procedure Div(R: in Flt; S,Tmp: in out Component) is <>;
  with procedure Quot(S1: in Component; R: in Flt; S2: in out Component) is <>;

package Vectors.More is

  function IsSharp is new VF_BProperty (Component,Vector,IsSharp);
  function Center0 is new VF_BProperty (Component,Vector,Center0);
  function Contains0 is new VF_LProperty (Component,Vector,Contains0);
  function Contains is new VF_LSimilar (Component,Vector,Contains);
  procedure ToErr is new VP_Modify1 (Component,Vector,ToErr);
  procedure ToErr is new VP_Map1 (Component,Vector,ToErr);
  procedure Center is new VP_Modify1 (Component,Vector,Center);
  procedure Center is new VP_Map1 (Component,Vector,Center);
  procedure ModCenter is new VP_Modify1 (Component,Vector,ModCenter);
  procedure ModCenter is new VP_Map1 (Component,Vector,ModCenter);
  procedure ErrMult(R: in Radius; V: in out Vector);
  procedure Union is new VP_Map1 (Component,Vector,Union);
  procedure Intersection(V1: in Vector; V2: in out Vector; Empty: out Logical);
  procedure Min(V: in Vector; S: in out Component);
  procedure Max(V: in Vector; S: in out Component);
  function Sup(V: Vector) return Flt;
  function Inf(V: Vector) return Flt;
  procedure Mult(R: in Flt; V: in out Vector; Tmp: in out Component);
  procedure Prod(R: in Flt; V1: in Vector; V2: in out Vector);
  procedure AddProd(R: in Flt; V1: in Vector; V2: in out Vector; Tmp: in out Component);
  procedure Div(R: in Flt; V: in out Vector; Tmp: in out Component);
  procedure Quot(V1: in Vector; R: in Flt; V2: in out Vector);

  procedure Evaluate(P: in Polynom1; R: in Flt; C: in out Component; Deg: in Natural);
  procedure Evaluate(P: in Polynom1; R: in Flt; C: in out Component);
  function Evaluate(P: Polynom1; R: Flt; Deg: Natural) return Component;
  function Evaluate(P: Polynom1; R: Flt) return Component;
  procedure Num_Der(P: in out Polynom1);                                         -- derivative
  procedure Num_MDer(P: in out Polynom1);                                        -- generator of dilation
  procedure Inv_MDer(P: in out Polynom1; CheckConst: in Boolean := True);        -- inverse of MDer

end Vectors.More;
