with Globals;
use Globals;

pragma Elaborate_All (Globals);

package body VGeneric is

  procedure VP_Modify1(V: in out Vector) is
  begin
    for K in V'Range loop Modify1(V(K)); end loop;
  end VP_Modify1;

  procedure VP_Modify2(V1,V2: in out Vector) is
  begin
    if CheckRange and then ((V1'First /= V2'First) or (V1'Last /= V2'Last)) then
      raise Dimension_Error with "VGeneric.VP_Modify2 error";
    end if;
    for K in V2'Range loop Modify2(V1(K),V2(K)); end loop;
  end VP_Modify2;

  procedure VP_Map1(V1: in Vector; V2: in out Vector) is
  begin
    if CheckRange and then ((V1'First /= V2'First) or (V1'Last /= V2'Last)) then
      raise Dimension_Error with "VGeneric.VP_Map1 error";
    end if;
    for K in V2'Range loop Map1(V1(K),V2(K)); end loop;
  end VP_Map1;

  function VF_Map1(V: Vector) return Vector is
    W: Vector(V'Range);
  begin
    for K in V'Range loop Map1(V(K),W(K)); end loop;
    return W;
  end VF_Map1;

  procedure VP_Map2(V1,V2: in Vector; V3: in out Vector) is
  begin
    if CheckRange and then ((V1'First /= V3'First) or (V1'Last /= V3'Last)
                              or (V2'First /= V3'First) or (V2'Last /= V3'Last)) then
      raise Dimension_Error with "VGeneric.VP_Map2 error";
    end if;
    for K in V3'Range loop Map2(V1(K),V2(K),V3(K)); end loop;
  end VP_Map2;

  function VF_Map2(V1,V2: Vector) return Vector is
    V3: Vector(V2'Range);
  begin
    if CheckRange and then ((V1'First /= V2'First) or (V1'Last /= V2'Last)) then
      raise Dimension_Error with "VGeneric.VF_Map2 error";
    end if;
    for K in V3'Range loop Map2(V1(K),V2(K),V3(K)); end loop;
    return V3;
  end VF_Map2;

  function VF_BProperty(V: Vector) return Boolean is
  begin
    for K in V'Range loop
      if not BProperty(V(K)) then return False; end if;
    end loop;
    return True;
  end VF_BProperty;

  function VF_LProperty(V: Vector) return Logical is
    L: Logical := True;
    LK: Logical;
  begin
    for K in V'Range loop
      LK := LProperty(V(K));
      if LK=False then return False; end if;
      if LK=Uncertain then L := Uncertain; end if;
    end loop;
    return L;
  end VF_LProperty;

  function VF_BSimilar(V1,V2: Vector) return Boolean is
  begin
    if CheckRange and then ((V1'First /= V2'First) or (V1'Last /= V2'Last)) then
      raise Dimension_Error with "VGeneric.VF_BSimilar error";
    end if;
    for K in V2'Range loop
      if not BSimilar(V1(K),V2(K)) then return False; end if;
    end loop;
    return True;
  end VF_BSimilar;

  function VF_LSimilar(V1,V2: Vector) return Logical is
    L: Logical := True;
    LK: Logical;
  begin
    if CheckRange and then ((V1'First /= V2'First) or (V1'Last /= V2'Last)) then
      raise Dimension_Error with "VGeneric.VF_LSimilar error";
    end if;
    for K in V2'Range loop
      LK := LSimilar(V1(K),V2(K));
      if LK=False then return False; end if;
      if LK=Uncertain then L := Uncertain; end if;
    end loop;
    return L;
  end VF_LSimilar;

end VGeneric;
